<?php
$user = getCurrentUser();
?>

<header class="bg-white border-b border-gray-200 lg:border-l">
    <div class="flex items-center justify-between h-16 px-4">
        <div class="flex items-center">
            <button onclick="toggleSidebar()" class="p-2 rounded-lg hover:bg-gray-100 lg:hidden">
                <i data-lucide="menu" class="w-6 h-6"></i>
            </button>
            <h1 class="ml-2 text-xl font-semibold text-gray-900 lg:ml-0">
                <?php echo $user['role'] === 'admin' ? 'Admin Dashboard' : 'Customer Portal'; ?>
            </h1>
        </div>

        <div class="flex items-center space-x-4">
            <button class="relative p-2 rounded-lg hover:bg-gray-100">
                <i data-lucide="bell" class="w-6 h-6 text-gray-600"></i>
                <span class="absolute top-1 right-1 w-2 h-2 bg-red-500 rounded-full"></span>
            </button>
            
            <div class="flex items-center">
                <div class="w-8 h-8 bg-amber-100 rounded-full flex items-center justify-center">
                    <span class="text-amber-600 font-semibold text-sm">
                        <?php echo strtoupper(substr($user['name'], 0, 1)); ?>
                    </span>
                </div>
            </div>
        </div>
    </div>
</header>