<?php
$current_page = basename($_SERVER['PHP_SELF']);
$user = getCurrentUser();

$admin_nav = [
    ['path' => '/admin/dashboard.php', 'icon' => 'layout-dashboard', 'label' => 'Dashboard'],
    ['path' => '/admin/reservations.php', 'icon' => 'calendar', 'label' => 'Reservations'],
    ['path' => '/admin/reviews.php', 'icon' => 'message-square', 'label' => 'Reviews'],
    ['path' => '/admin/notifications.php', 'icon' => 'bell', 'label' => 'Notifications'],
    ['path' => '/admin/tables.php', 'icon' => 'table', 'label' => 'Tables'],
    ['path' => '/admin/analytics.php', 'icon' => 'bar-chart-3', 'label' => 'Analytics'],
    ['path' => '/admin/customers.php', 'icon' => 'users', 'label' => 'Customers'],
    ['path' => '/admin/settings.php', 'icon' => 'settings', 'label' => 'Settings'],
];

$customer_nav = [
    ['path' => '/customer/dashboard.php', 'icon' => 'layout-dashboard', 'label' => 'Dashboard'],
    ['path' => '/customer/notifications.php', 'icon' => 'bell', 'label' => 'Notifications'],
    ['path' => '/customer/reservations.php', 'icon' => 'calendar', 'label' => 'Reservations'],
    ['path' => '/customer/reviews.php', 'icon' => 'message-square', 'label' => 'Reviews'],
    ['path' => '/customer/tables.php', 'icon' => 'table', 'label' => 'Tables'],
    ['path' => '/customer/settings.php', 'icon' => 'settings', 'label' => 'Settings'],
];

$nav_items = $user['role'] === 'admin' ? $admin_nav : $customer_nav;
?>

<!-- Sidebar -->
<div id="sidebar" class="fixed inset-y-0 left-0 z-50 w-64 bg-white border-r border-gray-200 sidebar-transition transform -translate-x-full lg:translate-x-0 lg:static lg:inset-0">
    <div class="flex flex-col h-full">
        <!-- Header -->
        <div class="flex items-center justify-center h-16 px-4 bg-amber-500 text-white">
            <i data-lucide="utensils" class="w-8 h-8 mr-2"></i>
            <span class="text-xl font-bold">Golden Fork</span>
        </div>

        <!-- User Info -->
        <div class="p-4 border-b border-gray-200">
            <div class="flex items-center">
                <div class="w-10 h-10 bg-amber-100 rounded-full flex items-center justify-center">
                    <span class="text-amber-600 font-semibold">
                        <?php echo strtoupper(substr($user['name'], 0, 1)); ?>
                    </span>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-900"><?php echo htmlspecialchars($user['name']); ?></p>
                    <p class="text-xs text-gray-500 capitalize"><?php echo $user['role']; ?></p>
                </div>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="flex-1 p-4 space-y-1">
            <?php foreach ($nav_items as $item): ?>
                <?php 
                $is_active = strpos($_SERVER['REQUEST_URI'], $item['path']) !== false;
                $active_class = $is_active ? 'bg-amber-100 text-amber-700 border-r-2 border-amber-500' : 'text-gray-600 hover:bg-gray-100 hover:text-gray-900';
                ?>
                <a href="<?php echo $item['path']; ?>" 
                   class="flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-colors duration-150 ease-in-out <?php echo $active_class; ?>">
                    <i data-lucide="<?php echo $item['icon']; ?>" class="w-5 h-5 mr-3"></i>
                    <?php echo $item['label']; ?>
                </a>
            <?php endforeach; ?>
        </nav>

        <!-- Logout -->
        <div class="p-4 border-t border-gray-200">
            <a href="/logout.php" class="flex items-center w-full px-3 py-2 text-sm font-medium text-red-600 rounded-lg hover:bg-red-50 transition-colors duration-150">
                <i data-lucide="log-out" class="w-5 h-5 mr-3"></i>
                Logout
            </a>
        </div>
    </div>
</div>

<!-- Overlay for mobile -->
<div id="overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 lg:hidden hidden"></div>